/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sam.timingAnalyzer;

import com.quantumdata.sam.Formats.VideoIDCode;
import com.quantumdata.sam.MainGui;
import com.quantumdata.sam.SignalAnalysisModule;
import com.quantumdata.sam.reporting.TimingAnalysisReport.Result;
import com.quantumdata.sam.reporting.TimingAnalysisReport.TestResults;
import com.quantumdata.sam.tableUtils.AttributiveCellTableModel;
import com.quantumdata.sam.tableUtils.ICellAttribute;
import com.quantumdata.sam.tableUtils.ICellBorder;
import com.quantumdata.sam.tableUtils.ICellColor;
import com.quantumdata.sam.tableUtils.ICellSpan;
import com.quantumdata.sam.timingAnalyzer.TimingAnalyzerEngine;
import com.quantumdata.sam.timingAnalyzer.TimingAnalyzerMeasuredDataTable;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.border.MatteBorder;

public class TimingAnalyzerMeasuredDataTableModel
extends AttributiveCellTableModel {
    private static final long serialVersionUID = 1L;
    public static final int DVIC_COLUMN_NUMBER = 1;
    public static final int NAME_COLUMN_NUMBER = 2;
    public static final int HTOT_COLUMN_NUMBER = 3;
    public static final int HRES_COLUMN_NUMBER = 4;
    public static final int HSPD_COLUMN_NUMBER = 5;
    public static final int HSPW_COLUMN_NUMBER = 6;
    public static final int HSPP_COLUMN_NUMBER = 7;
    public static final int HVPD_COLUMN_NUMBER = 8;
    public static final int VTOT_COLUMN_NUMBER = 9;
    public static final int VRES_COLUMN_NUMBER = 10;
    public static final int VSPD_COLUMN_NUMBER = 11;
    public static final int VSPW_COLUMN_NUMBER = 12;
    public static final int VSPP_COLUMN_NUMBER = 13;
    public static final int SCAN_COLUMN_NUMBER = 14;
    public static final int FRAT_COLUMN_NUMBER = 15;
    public static final int RESULT_COLUMN_NUMBER = 16;
    public static final int VIDEO_CODE_COLUMN_NUMBER = 1;
    public static final int FORMAT_COLUMN_NUMBER = 2;
    public static final int PIXEL_CLOCK_COLUMN_NUMBER = 3;
    public static final int H_TOTAL_COLUMN_NUMBER = 4;
    public static final int H_ACTIVE_COLUMN_NUMBER = 5;
    public static final int VIDEO_TO_HS_COLUMN_NUMBER = 6;
    public static final int HS_POLARITY_COLUMN_NUMBER = 7;
    public static final int HS_LEN_COLUMN_NUMBER = 8;
    public static final int V_TOTAL_COLUMN_NUMBER = 9;
    public static final int V_ACTIVE_COLUMN_NUMBER = 10;
    public static final int VS_TO_VIDEO_COLUMN_NUMBER = 11;
    public static final int VS_LEN_COLUMN_NUMBER = 12;
    public static final int VS_POLARITY_COLUMN_NUMBER = 13;
    public static final int HV_OFFSET_COLUMN_NUMBER = 14;
    public static final int HDMI_RESULT_COLUMN_NUMBER = 15;
    private TestResults tr = new TestResults();
    TimingAnalyzerMeasuredDataTable table;

    public TimingAnalyzerMeasuredDataTableModel(Vector vector, int n, TimingAnalyzerMeasuredDataTable timingAnalyzerMeasuredDataTable) {
        super(vector, n);
        this.table = timingAnalyzerMeasuredDataTable;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void insertRow(int n) {
        this.insertRow(n, (Vector)null);
        this.insertRow(n, (Vector)null);
        int n2 = this.measureData(n);
        switch (n2) {
            case 0: {
                ICellAttribute iCellAttribute = ((AttributiveCellTableModel)this.table.getModel()).getCellAttribute();
                iCellAttribute.insertRow();
                iCellAttribute.insertRow();
                break;
            }
            case 2803: {
                this.removeRow(n);
                this.removeRow(n);
                MainGui.getStatus().setForeground(Color.RED);
                MainGui.getStatus().setText("No Input Signal!");
                break;
            }
            case -1: {
                MainGui.getStatus().setForeground(Color.RED);
                MainGui.getStatus().setText("Closest Matching Format Not Found!");
                ICellAttribute iCellAttribute = ((AttributiveCellTableModel)this.table.getModel()).getCellAttribute();
                iCellAttribute.insertRow();
                iCellAttribute.insertRow();
                break;
            }
        }
        for (int i = 0; i < this.tr.getResult().size(); ++i) {
            this.tr.getResult().get(i).setTestnumber(new Integer(i + 1).toString());
        }
        this.formatData();
    }

    public void replaceRow(int n) {
        this.deleteRow(n);
        this.insertRow(n);
    }

    public void deleteRow(int n) {
        this.removeRow(n);
        this.removeRow(n);
        this.tr.getResult().remove(n / 2);
        for (int i = 0; i < this.tr.getResult().size(); ++i) {
            this.tr.getResult().get(i).setTestnumber(new Integer(i + 1).toString());
        }
        ICellAttribute iCellAttribute = ((AttributiveCellTableModel)this.table.getModel()).getCellAttribute();
        iCellAttribute.deleteRow();
        iCellAttribute.deleteRow();
        this.formatData();
    }

    public Object getValueAt(int n, int n2) {
        Result result = this.tr.getResult().get(n / 2);
        if (this.table.isHdmiCTSDisplayFilterMode()) {
            switch (n2) {
                case 0: {
                    return result.getTestnumber();
                }
                case 1: {
                    return VideoIDCode.getDvicString(Integer.parseInt(result.getDvic()));
                }
                case 2: {
                    if (!result.getDvic().equalsIgnoreCase("0")) {
                        return "<HTML><font size=2>" + VideoIDCode.getVideoIDCodeString(Integer.parseInt(result.getDvic())) + "</HTML>";
                    }
                    return result.getClosestFormat();
                }
                case 3: {
                    return new DecimalFormat("##.000").format(Double.parseDouble(n % 2 == 0 ? result.getPrat() : result.getFormatPrat()) / 1000000.0);
                }
                case 4: {
                    return n % 2 == 0 ? result.getHtot() : result.getFormatHtot();
                }
                case 5: {
                    return n % 2 == 0 ? result.getHres() : result.getFormatHres();
                }
                case 6: {
                    return n % 2 == 0 ? result.getHspd() : result.getFormatHspd();
                }
                case 7: {
                    return n % 2 == 0 ? (result.getHspp().equals("1") ? "+" : "-") : (result.getFormatHspp().equals("1") ? "+" : "-");
                }
                case 8: {
                    return n % 2 == 0 ? result.getHspw() : result.getFormatHspw();
                }
                case 9: {
                    double d = n % 2 == 0 ? Double.parseDouble(result.getVtot()) / Double.parseDouble(result.getScan()) : Double.parseDouble(result.getFormatVtot()) / Double.parseDouble(result.getFormatScan());
                    return new Integer(new Double(d).intValue()).toString();
                }
                case 10: {
                    double d = n % 2 == 0 ? Double.parseDouble(result.getVres()) / Double.parseDouble(result.getScan()) : Double.parseDouble(result.getFormatVres()) / Double.parseDouble(result.getFormatScan());
                    return new Integer(new Double(d).intValue()).toString();
                }
                case 11: {
                    int n3;
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    if (n % 2 == 0) {
                        d4 = Double.parseDouble(result.getVtot());
                        d3 = Double.parseDouble(result.getScan());
                        d2 = Double.parseDouble(result.getVres());
                        d = Double.parseDouble(result.getVspd());
                        n3 = Integer.parseInt(result.getVtot());
                    } else {
                        d4 = Double.parseDouble(result.getFormatVtot());
                        d3 = Double.parseDouble(result.getFormatScan());
                        d2 = Double.parseDouble(result.getFormatVres());
                        d = Double.parseDouble(result.getFormatVspd());
                        n3 = Integer.parseInt(result.getFormatVtot());
                    }
                    double d5 = n3 % 2 == 0 ? d4 / d3 - d2 / d3 - d : (d4 - d3 + 1.0) / d3 - d2 / d3 - d;
                    return new Integer(new Double(d5).intValue()).toString();
                }
                case 12: {
                    return n % 2 == 0 ? result.getVspw() : result.getFormatVspw();
                }
                case 13: {
                    return n % 2 == 0 ? (result.getVspp().equals("1") ? "+" : "-") : (result.getFormatVspp().equals("1") ? "+" : "-");
                }
                case 14: {
                    return n % 2 == 0 ? result.getHvpd() : result.getFormatHvpd();
                }
                case 15: {
                    return result.getTestStatus();
                }
            }
        } else {
            switch (n2) {
                case 0: {
                    return result.getTestnumber();
                }
                case 1: {
                    return VideoIDCode.getDvicString(Integer.parseInt(result.getDvic()));
                }
                case 2: {
                    return result.getClosestFormat();
                }
                case 3: {
                    return n % 2 == 0 ? result.getHtot() : result.getFormatHtot();
                }
                case 4: {
                    return n % 2 == 0 ? result.getHres() : result.getFormatHres();
                }
                case 5: {
                    return n % 2 == 0 ? result.getHspd() : result.getFormatHspd();
                }
                case 6: {
                    return n % 2 == 0 ? result.getHspw() : result.getFormatHspw();
                }
                case 8: {
                    return n % 2 == 0 ? result.getHvpd() : result.getFormatHvpd();
                }
                case 7: {
                    return n % 2 == 0 ? result.getHspp() : result.getFormatHspp();
                }
                case 9: {
                    return n % 2 == 0 ? result.getVtot() : result.getFormatVtot();
                }
                case 10: {
                    return n % 2 == 0 ? result.getVres() : result.getFormatVres();
                }
                case 11: {
                    return n % 2 == 0 ? result.getVspd() : result.getFormatVspd();
                }
                case 12: {
                    return n % 2 == 0 ? result.getVspw() : result.getFormatVspw();
                }
                case 13: {
                    return n % 2 == 0 ? result.getVspp() : result.getFormatVspp();
                }
                case 14: {
                    return n % 2 == 0 ? result.getScan() : result.getFormatScan();
                }
                case 15: {
                    double d = n % 2 == 0 ? Double.parseDouble(result.getHrat()) / Double.parseDouble(result.getVtot()) : Double.parseDouble(result.getFormatHrat()) / Double.parseDouble(result.getFormatVtot());
                    return new DecimalFormat("##.000").format(d);
                }
                case 16: {
                    return result.getTestStatus();
                }
            }
        }
        return null;
    }

    public int measureData(int n) {
        Result result = TimingAnalyzerEngine.retrieveDataFromInstrument(true);
        if (result == null) {
            return 2803;
        }
        String string = TimingAnalyzerEngine.getCurrentFormatName();
        String string2 = TimingAnalyzerEngine.getClosestFormatName();
        if (string2.equals("") || string2 == null || !TimingAnalyzerEngine.setClosestFormat(string2)) {
            result.setFormatScan(result.getScan());
            result.setFormatHres(result.getHres());
            result.setFormatVres(result.getVres());
            result.setFormatVtot(result.getVtot());
            result.setFormatHtot(result.getHtot());
            result.setFormatHrat(result.getHrat());
            result.setFormatHspw(result.getHspw());
            result.setFormatVspw(result.getVspw());
            result.setFormatHspd(result.getHspd());
            result.setFormatVspd(result.getVspd());
            result.setFormatHspp(result.getHspp());
            result.setFormatVspp(result.getVspp());
            result.setFormatHvpd(result.getHvpd());
            result.setClosestFormat("UNKNOWN");
            result.setDvic("0");
            result.setHdmiSpecFormatName("UNKNOWN");
            result.setFormatPrat(result.getPrat());
            result.setTestStatus("??");
            result.setPerfectMatch("0");
            result.setTestnumber(new Integer(n / 2 + 1).toString());
            this.tr.getResult().add(n / 2, result);
            return -1;
        }
        Result result2 = TimingAnalyzerEngine.retrieveDataFromInstrument(false);
        String string3 = TimingAnalyzerEngine.getClosestFormatDvic();
        if (string != null) {
            TimingAnalyzerEngine.restorePreviousFormat(string);
        }
        if (result2 != null && string3 != null) {
            double d;
            RemoteInstrument remoteInstrument = SignalAnalysisModule.ri;
            InstrumentResponse instrumentResponse = remoteInstrument.sendCmd("ncpp?");
            int n2 = instrumentResponse.getResponse().equals("2") ? 2 : 1;
            result.setFormatHres(Integer.toString(Integer.valueOf(result2.getHres()) * n2));
            result.setFormatHtot(Integer.toString(Integer.valueOf(result2.getHtot()) * n2));
            result.setFormatHspw(Integer.toString(Integer.valueOf(result2.getHspw()) * n2));
            result.setFormatHspd(Integer.toString(Integer.valueOf(result2.getHspd()) * n2));
            result.setFormatScan(result2.getScan());
            result.setFormatVres(result2.getVres());
            result.setFormatVtot(result2.getVtot());
            result.setFormatHrat(result2.getHrat());
            result.setFormatVspw(result2.getVspw());
            result.setFormatVspd(result2.getVspd());
            result.setFormatHspp(result2.getHspp());
            result.setFormatVspp(result2.getVspp());
            result.setFormatHvpd(result2.getHvpd());
            result.setClosestFormat(string2);
            result.setDvic(string3);
            if (Integer.valueOf(string3) == 0) {
                result.setHdmiSpecFormatName(string2);
            } else {
                result.setHdmiSpecFormatName(VideoIDCode.getVideoIDCodeString(Integer.valueOf(string3)));
            }
            result.setFormatPrat(result2.getPrat());
            if (result.getHtot().equals(result.getFormatHtot()) && result.getHres().equals(result.getFormatHres()) && result.getHspd().equals(result.getFormatHspd()) && result.getHspw().equals(result.getFormatHspw()) && result.getHspp().equals(result.getFormatHspp()) && result.getHvpd().equals(result.getFormatHvpd()) && result.getVtot().equals(result.getFormatVtot()) && result.getVres().equals(result.getFormatVres()) && result.getVspd().equals(result.getFormatVspd()) && result.getVspw().equals(result.getFormatVspw()) && result.getVspp().equals(result.getFormatVspp()) && result.getScan().equals(result.getFormatScan())) {
                if (result.getHrat().equals(result.getFormatHrat())) {
                    result.setPerfectMatch("1");
                } else {
                    result.setPerfectMatch("0");
                }
                d = Double.parseDouble(result.getHrat());
                double d2 = Double.parseDouble(result.getFormatHrat());
                if (d >= d2 * 0.994 && d <= d2 * 1.005) {
                    result.setTestStatus("PASS");
                } else {
                    result.setTestStatus("FAIL");
                }
            } else {
                result.setTestStatus("FAIL");
                result.setPerfectMatch("0");
            }
            result.setTestnumber(new Integer(n / 2 + 1).toString());
            d = Double.parseDouble(result.getHrat()) / Double.parseDouble(result.getVtot());
            result.setFrat(new DecimalFormat("##.000").format(d));
            d = Double.parseDouble(result2.getHrat()) / Double.parseDouble(result2.getVtot());
            result.setFormatFrat(new DecimalFormat("##.000").format(d));
            this.tr.getResult().add(n / 2, result);
            return 0;
        }
        return -1;
    }

    public void formatData() {
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black);
        ICellColor iCellColor = (ICellColor)((Object)this.getCellAttribute());
        ICellSpan iCellSpan = (ICellSpan)((Object)this.getCellAttribute());
        ICellBorder iCellBorder = (ICellBorder)((Object)this.getCellAttribute());
        for (int i = 0; i < this.getRowCount(); ++i) {
            int n;
            if (i % 2 == 0) {
                for (n = 0; n < this.getColumnCount(); ++n) {
                    if (((String)this.getValueAt(i, n)).equals((String)this.getValueAt(i + 1, n))) {
                        iCellSpan.combine(i, i + 1, n);
                        iCellBorder.setBorder(matteBorder, i, n);
                        continue;
                    }
                    if (this.table.isHdmiCTSDisplayFilterMode() && n == 3) {
                        iCellColor.setBackground(new Color(253, 184, 35), i, n);
                        continue;
                    }
                    if (n == 15 && !this.table.isHdmiCTSDisplayFilterMode()) {
                        iCellColor.setBackground(new Color(253, 184, 35), i, n);
                        continue;
                    }
                    iCellColor.setBackground(Color.RED, i, n);
                    iCellColor.setForeground(Color.WHITE, i, n);
                }
            } else {
                for (n = 0; n < this.getColumnCount(); ++n) {
                    iCellBorder.setBorder(matteBorder, i, n);
                }
            }
            if (this.tr.getResult().get(i / 2).getTestStatus().equals("PASS")) {
                iCellColor.setBackground(Color.GREEN, i, this.getColumnCount() - 1);
                continue;
            }
            iCellColor.setBackground(Color.RED, i, this.getColumnCount() - 1);
            iCellColor.setForeground(Color.WHITE, i, this.getColumnCount() - 1);
        }
    }

    public TestResults getTr() {
        return this.tr;
    }
}

